
-- Dummy-Tabelle erzeugen
create table umsaetze as
select s.time_id umsatz_tag,
       c.channel_desc verkaufs_kanal,
       p.prod_name produkt, 
       sum(quantity_sold * amount_sold) umsatz
  from sales s, products p, channels c
 where s.prod_id = p.prod_id
   and s.channel_id = c.channel_id
 group by s.time_id, c.channel_desc, p.prod_name;
 
-- Index-Set erzeugen
begin
  ctx_ddl.create_index_set('umsaetze_iset');
  ctx_ddl.add_index('umsaetze_iset','umsatz'); 
  ctx_ddl.add_index('umsaetze_iset','verkaufs_kanal'); 
end;
/

-- CTXCAT-Index erzeugen
create index idx_umsaetze_cat on umsaetze(produkt) 
       indextype is ctxsys.ctxcat
       parameters ('index set umsaetze_iset');
       
-- Statistiken der neuen Tabelle aktualisieren                 
call dbms_stats.gather_table_stats('SH', 'UMSAETZE');

select umsatz_tag tag, verkaufs_kanal kanal,
       produkt, umsatz
  from umsaetze
 where catsearch(produkt, 'CD13272', 
                 'order by umsatz desc') > 0
   and umsatz > 7400;
       
select umsatz_tag tag, verkaufs_kanal kanal,
       produkt, umsatz
  from umsaetze
 where catsearch(produkt, 'CD13272', 
                 'verkaufs_kanal = ''Internet''
                  order by umsatz desc') > 0
   and umsatz > 5000;

select umsatz_tag tag, verkaufs_kanal kanal,
       produkt, umsatz
  from umsaetze
 where verkaufs_kanal = 'Internet'
   and produkt like '%CD13272%'
   and umsatz > 5000;
   
select distinct dr$token
  from DR$IDX_UMSAETZE_CAT$I;


/* Beispiel für einen CTXRULE-Index */
-- Regeltabelle erzeugen
create table text_category_rules(
  category_id number,
  category_rule varchar2(200 char));

-- Regeln einfügen
insert into text_category_rules
select 1, 'index' from dual union all
select 1, 'merge or insert or update or delete' from dual union all
select 1, 'sum or avg or max or count' from dual union all
select 1, 'sum and over' from dual;

commit;

-- Index erzeugen
create index idx_text_category_rules 
    on text_category_rules(category_rule)
       indextype is ctxsys.ctxrule;


-- Zwei Beispielabfragen
select category_id, category_rule
  from text_category_rules
 where matches(category_rule,
               'Lassen Sie uns über die merge-Anweisung sprechen') > 0;
               
select category_id, category_rule
  from text_category_rules
 where matches(category_rule,
               'Analytische Funktionen (z.B. sum(sal) over (order by emp)') > 0;
